/* globals Twitch */
import StreamPreviewComponent from 'web-client/components/stream-preview';
import BanTimeoutModalMixin from 'web-client/mixins/communities/ban-or-timeout-modal';
import InteractivityDeferredComponent from 'web-client/mixins/interactivity-deferred-component';
import injectService from 'ember-service/inject';
import computed from 'ember-computed';
import run from 'ember-runloop';

const UI_CONTEXT = 'community_page';

export default StreamPreviewComponent.extend(BanTimeoutModalMixin, InteractivityDeferredComponent, {
  communities: injectService(),
  session: injectService(),
  tracking: injectService(),
  showActions: false,

  userId: computed.alias('stream.channel._id'), // Required for the BanTimeoutModalMixin
  userLogin: computed.alias('stream.channel.name'), // Required for the BanTimeoutModalMixin
  userDisplayName: computed.alias('stream.channel.display_name'), // Required for the BanTimeoutModalMixin

  init() {
    this._super(...arguments);
    this.set('stream.gameBoxart', Twitch.uri.gameBoxArtJpg(this.get('stream.game')));
    this.set('channelHref', Twitch.uri.channel(this.get('stream.channel.name')));
  },

  didInsertElement() {
    this._super();
    run.scheduleOnce('afterRender', this, this.reportInteractive);
  },

  _getTrackingObject(user) {
    return {
      community_id: this.get('communities.communityInfo._id'),
      community_name: this.get('communities.communityInfo.name'),
      login: this.get('session.userData.login'),
      is_subadmin: this.get('session.userData.is_admin'),
      is_admin: this.get('session.userData.is_staff'),
      is_community_owner: parseInt(this.get('communities.communityInfo.owner_id')) === this.get('session.userData.id'),
      is_community_mod : parseInt(this.get('communities.communityInfo.owner_id')) !== this.get('session.userData.id'),
      channel: user.name,
      ui_context: UI_CONTEXT
    };
  },

  timeoutUserCallback(duration) {
    this.set('stream.isBannedorTimedout', true);
    let trackingObject = this._getTrackingObject(this.get('stream.channel'));
    trackingObject.duration = duration;
    this.get('tracking').trackEvent({
      event: 'community_timeout',
      data: trackingObject
    });
  },

  banUserCallback() {
    this.set('stream.isBannedorTimedout', true);
    let trackingObject = this._getTrackingObject(this.get('stream.channel'));
    this.get('tracking').trackEvent({
      event: 'community_ban',
      data: trackingObject
    });
  },

  actions: {
    handleStreamClick(index) {
      this.get('tracking').trackEvent({
        event: 'channel_select_click',
        data: {
          login: this.get('session.userData.login'),
          url: this.get('channelHref'),
          community_id: this.get('communities.communityInfo._id'),
          community_name: this.get('communities.communityInfo.name'),
          displayed_ccu: this.get('stream.viewers'),
          rank_index: index
        }
      });
      this._super(...arguments);
    },

    toggleActions() {
      this.set('showActions', !this.get('showActions'));
    }
  }
});
