import Component from 'ember-component';
import injectService from 'ember-service/inject';
import on from 'ember-evented/on';
import computed from 'ember-computed';
import { libraries as libs } from 'web-client/utilities/conversations-util';

export default Component.extend({
  store: injectService(),
  classNames: ['conversation-settings-menu'],
  session: injectService(),
  tracking: injectService(),
  conversations: injectService("twitch-conversations/conversations"),

  userToIgnore: computed.readOnly('thread.otherUsername'),
  userDisplayname: computed.readOnly('thread.otherDisplayname'),

  goToChannelText: computed('userDisplayname', function () {
    let translation = libs.i18n("Go to {{name}}'s Channel");
    return translation.replace('{{name}}', this.get('userDisplayname'));
  }),

  blockText: computed('userDisplayname', function () {
    let translation = libs.i18n("Block {{name}}...");
    return translation.replace('{{name}}', this.get('userDisplayname'));
  }),

  unblockText: computed('userDiplayname', function () {
    let translation = libs.i18n("Unblock {{name}}...");
    return translation.replace('{{name}}', this.get('userDisplayname'));
  }),

  getFriendStatus: on('init', function () {
    this.get('store').queryRecord('friends-list-user', {
      type: 'friend-status',
      login: this.get('thread.otherUser.username')
    }).then(friendStatus => {
      if (this.isDestroyed) { return; }
      this.set('friendStatus', friendStatus);
    });
  }),

  _fireConvoModTrackingEvent(action) {
    this.get('tracking').trackEvent({
      event: 'chat_convo_mod',
      data: {
        conversation_id: this.get('thread.id'),
        action,
        login: this.get('session.userData.login')
      }
    });
  },

  ignoreWithReason(reason, source) {
    this.get('conversations').ignoreUser(this.get('thread'), reason, source).then(() => {
      if (this.isDestroyed) { return; }
      this.get('tracking').trackEvent({
        event: 'chat_ignore_client',
        data: {
          ui_context: 'dock',
          from_login: this.get('session.userData.login'),
          ignored_login: this.get('userToIgnore'),
          reason: reason || 'Other',
          source: source
        }
      });
    });
  },

  actions: {
    addFriend() {
      let otherUserId = this.get('thread.otherUser.id');
      if (!otherUserId) {
        return;
      }

      this.get('store').createRecord('friends-list-request', {
        friendId: otherUserId,
        friendLogin: this.get('thread.otherUser.username')
      }).save().then(() => {
        if (this.isDestroyed) { return; }
        this.get('tracking').trackEvent({
          event: 'friend_request',
          data: {
            request_id: `${this.get('session.userData.id')}_${otherUserId}`,
            login: this.get('session.userData.login'),
            target_login: this.get('thread.otherUser.username'),
            ui_context: 'conversation'
          }
        });
      });
    },
    muteConversation() {
      this.get('thread').set('isMuted', true);
      this.get('thread').save();
      this._fireConvoModTrackingEvent('mute');
    },

    unmuteConversation() {
      this.get('thread').set('isMuted', false);
      this.get('thread').save();
      this._fireConvoModTrackingEvent('unmute');
    },

    unignoreUser() {
      this.get('conversations').unignoreUser(this.get('thread'));
    },

    openIgnoreForm() {
      this.sendAction('openInModal', 'shared/ignore-form-modal', this);
    },

    ignoreUserWithReason(reason) {
      this.ignoreWithReason(reason, "ignore_modal");
      this.sendAction('closeModal');
    },

    ignoreAsHarassment() {
      this.ignoreWithReason('Harassment', "conversations_button");
    },

    ignoreAsSpam() {
      this.ignoreWithReason('Spam', "conversations_button");
    }
  }
});
