import Component from 'ember-component';
import computed from 'ember-computed';
import injectService from 'ember-service/inject';

export default Component.extend({
  classNames: ['conversation-settings-menu'],
  conversations: injectService('twitch-conversations/conversations'),
  tracking: injectService(),
  isDNDEnabled: computed.readOnly('conversations.isDNDEnabled'),

  actions: {
    markAllAsRead() {
      this.get('conversations').markAllRead().then(() => {
        if (this.isDestroyed) { return; }
        this.sendAction('hideSettings');
      });

      this.get('tracking').trackEvent({
        event: 'chat_convo_mod_global',
        data: {
          action: 'mark_all_read'
        }
      });
    },

    toggleDND() {
      this.get('conversations').toggleDND();

      let action = this.get('isDNDEnabled') ? 'do_not_disturb_on' : 'do_not_disturb_off';
      this.get('tracking').trackEvent({
        event: 'chat_convo_mod_global',
        data: { action }
      });
    }
  }
});
