import Component from 'ember-component';
import computed from 'ember-computed';
import injectService from 'ember-service/inject';
import { libraries as libs } from 'web-client/utilities/conversations-util';

export default Component.extend({
  classNameBindings: [':ignore-cta', 'shouldShowSpamCTA::hidden'],
  session: injectService(),
  tracking: injectService(),
  conversations: injectService('twitch-conversations/conversations'),
  shouldShowSpamCTA: true,

  thankYouText: computed(function () {
    let translation = libs.i18n(
        `Thank you for helping us fight spam. We've blocked {{name}} from sending you further whispers. You can undo
        this from the Whisper Settings Menu.`.replace(/\s\s+/g, ' ')
    );
    return translation.replace('{{name}}', this.get('conversation.thread.otherDisplayname'));
  }),

  actions: {
    ignoreAsSpam() {
      this.get('conversations').ignoreUser(this.get('conversation.thread'), 'Spam').then(() => {
        this.get('tracking').trackEvent({
          event: 'chat_ignore_client',
          data: {
            ui_context: 'dock_spam_cta',
            from_login: this.get('session.userData.login'),
            ignored_login: this.get('conversation.thread.otherUsername'),
            reason: 'Spam'
          }
        });
      });
    },

    archive() {
      this.get('conversations').archive(this.get('conversation'));
      this.get('tracking').trackEvent({
        event: 'chat_convo_mod',
        data: {
          conversation_id: this.get('conversation.thread.id'),
          action: 'archive',
          login: this.get('session.userData.login')
        }
      });
    },

    markNotSpam() {
      this.set('shouldShowSpamCTA', false);
      this.get('conversations').markNotSpam(this.get('conversation'));
      this.get('tracking').trackEvent({
        event: 'chat_convo_mod',
        data: {
          conversation_id: this.get('conversation.thread.id'),
          action: 'mark_not_spam',
          login: this.get('session.userData.login')
        }
      });
    }
  }
});
