import computed from 'ember-computed';
import Component from 'ember-component';

export default Component.extend({
  classNames: ['timestamp-line', 'block-divider'],

  formattedTime: computed('time', function () {
    let formatted = '';
    if (this.get('time').today()) {
      formatted += 'Today, ';
    } else {
      formatted += `${this.get('time').toLocaleDateString()}, `;
    }

    formatted += this.get('time').toLocaleTimeString();
    return formatted;
  })
});
