/* globals $ */
import Component from 'ember-component';
import computed from 'ember-computed';
import injectService from 'ember-service/inject';
import { isPresent } from 'ember-utils';

export default Component.extend({
  classNames: ['activity-comment', 'pos-relative', 'pd-b-1'],
  feeds: injectService(),

  truncateAfter: 300,
  numPreviewLines: 5,
  reaction: computed('comment.reactions.[]', function () {
    return this.get('comment.reactions.firstObject') || {count: 0};
  }),
  reactionIsActive: computed('reaction.userIds.[]', function () {
    let reaction = this.get('reaction');
    return reaction ? isPresent(reaction.userIds) : false;
  }),

  actions: {
    showFullComment() {
      let feeds = this.get('feeds');
      let comment = this.get('comment');

      this.set('showTruncatedComment', false);
      feeds.trackEvent('feed_comment_expand', this.get('trackingInfo'), {
        status_update_id: comment.get('post.id'),
        comment_id: comment.get('id')
      });
    },

    setReaction() {
      let feeds = this.get('feeds');
      let comment = this.get('comment');
      let reactionIsActive = this.get('reactionIsActive');
      let emote = {
        name: 'endorse',
        id: 'endorse'
      };

      if (!feeds.get('meAsFeedUser')) {
        let isModal = this.get('isModal');
        if (!isModal && $.login instanceof Function) {
          $.login();
        }
        return;
      }

      feeds.setReactionForMessage(comment, emote).then(() => {
        if (this.isDestroyed) { return; }
        feeds.trackEvent('feed_comment_reaction', this.get('trackingInfo'), {
          status_update_id: comment.get('post.id'),
          comment_id: comment.get('id'),
          action: reactionIsActive ? 'remove' : 'add'
        });
      });
    },

    deleteComment(comment) {
      return this.get('feeds').deleteMessage(comment);
    }
  }
});
