import Component from 'ember-component';
import injectService from 'ember-service/inject';
import computed from 'ember-computed';

import { JTV_USER_PICTURES_404_USER_150X150_URL } from 'web-client/utilities/urls/static-cdn';

export default Component.extend({
  classNames: ['activity-card__comments'],
  feeds: injectService(),

  loadingMore: false,
  showEmoticonSelector: false,
  userClickedLoadMoreComments: 0,
  userProfileImage: computed('feeds.meAsFeedUser.profileImage', function () {
    return this.get('feeds.meAsFeedUser.profileImage') || JTV_USER_PICTURES_404_USER_150X150_URL;
  }),
  commentsNotLoaded: computed('comments.[]', 'commentsTotal', function () {
    let commentsTotal = this.get('commentsTotal');
    let comments = this.get('comments');
    return commentsTotal - comments.length;
  }),

  actions: {
    loadMoreComments() {
      let feeds = this.get('feeds');
      let postId = this.get('postId');

      this.set('loadingMore', true);
      feeds.loadMoreComments(postId).then(() => {
        if (this.isDestroyed) { return; }
        let userClickedLoadMoreComments = this.get('userClickedLoadMoreComments');

        this.set('userClickedLoadMoreComments', userClickedLoadMoreComments + 1);
        this.set('loadingMore', false);
        feeds.trackEvent('feed_comment_display_expand', this.get('trackingInfo'), {
          status_update_id: postId,
          expand_count: this.get('userClickedLoadMoreComments')
        });
      });
    },

    createComment(params) {
      let feeds = this.get('feeds');
      params.postId = this.get('postId');
      return feeds.createComment(params).then((comment) => {
        if (this.isDestroyed) { return; }
        let trackingProps = {
          comment_id: comment.get('id'),
          channel: comment.get('post.user.login'),
          content: comment.get('body'),
          status_update_id: params.postId
        };
        feeds.trackEvent('feed_comment', this.get('trackingInfo'), trackingProps);
      });
    }
  }
});
