import Component from 'ember-component';
import computed from 'ember-computed';
import { isPresent } from 'ember-utils';

import { EMOTICONS_V1_URL } from 'web-client/utilities/urls/static-cdn';

export default Component.extend({
  tagName: 'button',
  classNameBindings:  [':activity-button', ':activity-button--text', 'isActive:activity-button--selected'],

  isActive: computed('reaction.userIds', function () {
    let reaction = this.get('reaction');
    return isPresent(reaction.userIds);
  }),

  srcSet: computed('reaction.emoteId', function () {
    let emoteId = this.get('reaction.emoteId');

    return `${ EMOTICONS_V1_URL }/${ emoteId }/2.0`;
  }),

  url: computed('reaction.emoteId', function () {
    let emoteId = this.get('reaction.emoteId');

    return `${ EMOTICONS_V1_URL }/${ emoteId }/1.0`;
  }),

  click: function () {
    let reaction = this.get('reaction');
    let emote = {
      id: reaction.emoteId || null,
      name: reaction.emoteName || null
    };

    this.sendAction('action', emote);
  }
});
