import computed from 'ember-computed';
import Component from 'ember-component';
import injectService from 'ember-service/inject';

export default Component.extend({
  classNames: ['mg-l-1'],
  tagName: 'span',

  // Passed in
  userId: null,
  user: null,

  store: injectService(),

  statusIndicatorClass: computed('user.availability', function () {
    let availability = this.get('user.availability');
    if (availability === 'online') {
      return 'presence--online';
    } else if (availability === 'idle') {
      return 'presence--idle';
    }

    return 'presence--invisible';
  }),

  didReceiveAttrs() {
    this._super(...arguments);
    let user = this.get('store').peekRecord('friends-list-user', this.get('userId'));
    if (user) {
      this.set('user', user);
    }
  }
});
