import Component from 'ember-component';
import injectService from 'ember-service/inject';
import { InvalidError } from 'ember-ajax/errors';
export default Component.extend({
  classNames: ['js-friend-search-results friend-list--search-results'],
  users: null,
  store: injectService(),

  actions: {
    addFriend(user) {
      this.get('store').createRecord('friends-list-request', {
        friendId: user.get('id'),
        friendLogin: user.get('login')
      }).save().then(null, error => {
        // 422 in `ember-ajax` becomes an InvalidError
        if (error instanceof InvalidError) {
          user.get('errors').add('isRequested', 'Requested user already');
        } else {
          user.set('didError', true);
        }
      });
    }
  }
});
