import Component from 'ember-component';

export default Component.extend({
  query: '',

  willDestroyElement() {
    this._clear();
    this._super();
  },

  _clear() {
    this.set('query', '');
    this.attrs.search('');
  },

  actions: {
    search(query, event) {
      if (event.keyCode !== 27) { // Don't trigger search on Esc
        this.attrs.search(query);
      }
    },

    clear() {
      this._clear();
    }
  }
});
