import on from 'ember-evented/on';
import computed from 'ember-computed';
import Component from 'ember-component';
import injectService from 'ember-service/inject';

const STRANGER_THRESHOLD = 50;

export default Component.extend({
  classNames: ['js-friends-settings', 'js-requests', 'tower', 'tower--bleed', 'tower--300', 'tower--gutter-sm', 'pd-b-10', 'mg-b-10'],
  requests: injectService('twitch-friends-list/requests'),
  store: injectService(),
  _fetchRequests: on('init', function () {
    this.get('requests').fetchNewRequests({
      limit: 100
    });
  }),

  requestsOverThreshold: computed.gt('sortedRequests.length', STRANGER_THRESHOLD),

  sortedRequests: computed('requests.pending.[]', function () {
    return this.get('requests.pending').sort(this.strangerSort);
  }),
  nonStrangerRequests: computed('requests.pending.[]', function () {
    return this.get('requests.pending').filterBy('isStranger', false);
  }),
  strangerRequests: computed('requests.pending.[]', function () {
    return this.get('requests.pending').filterBy('isStranger');
  }),

  strangerSort(f1, f2) {
    return f1.get('isStranger') - f2.get('isStranger');
  },


  actions: {
    onResolve(request) {
      this.runTask(() => {
        this._removeRequest(request);
      }, 500);

      // Refresh the friends to get the updated presence, including the new friend that was just accepted
      this.get('store').query('friends-list-user', {
        type: 'friends'
      });
    }
  }
});
