import Component from 'ember-component';
import computed from 'ember-computed';
import injectService from 'ember-service/inject';
import OnsiteNotificationTracking from 'web-client/mixins/onsite-notifications/tracking';

// Note: The parent container of the infinite scrolling list must be `tse-scroll-content` for
// infinite-scroll-slug to work
export default Component.extend(OnsiteNotificationTracking, {
  onsite: injectService('onsite-notifications'),
  notifications: computed.readOnly('onsite.notifications'),
  hasMorePages: computed.readOnly('onsite.hasMorePages'),
  isEmpty: computed.readOnly('onsite.isEmpty'),
  loadingMore: computed.readOnly('onsite.loadingMore'),

  // This computed is used in a `disabled` attribute. It must either return
  // true or `null`; the disabled attribute is not rendered when this returns `null`.
  isMarkAllReadDisabled: computed('isEmpty', function() {
    return this.get('isEmpty') ? true : null;
  }),

  actions: {
    markAllRead() {
      this.trackNotificationCenterInteraction('mark_all_read', this.get('newNotificationsCount'));
      this.get('onsite').markAllRead();
    },

    loadMore() {
      this.get('onsite').loadMoreNotifications();
    }
  }
});
