import Component from 'ember-component';
import computed from 'ember-computed';
import injectService from 'ember-service/inject';
import OnsiteNotificationTracking from 'web-client/mixins/onsite-notifications/tracking';

// Fading in is handled by the `anim__fadeIn` class
export default Component.extend(OnsiteNotificationTracking, {
  impressionTracking: injectService(),

  didInsertElement() {
    this._super(...arguments);
    this.get('impressionTracking').registerComponent(this, 'enteredViewport');
  },

  willDestroyElement() {
    this._super(...arguments);
    this.get('impressionTracking').deregisterComponent(this);
  },

  primaryCtaText: computed.readOnly('notification.primaryCta.body'),

  mouseEnter() {
    this.sendAction('cancelTimer');
  },

  mouseLeave() {
    this.sendAction('startTimer');
  },

  actions: {
    enteredViewport() {
      this.trackNotificationImpression('toast', this.get('notification'));
      this.get('impressionTracking').deregisterComponent(this);
    }
  }
});
