import Component from 'ember-component';
import computed from 'ember-computed';
import injectService from 'ember-service/inject';
import OnsiteNotificationTracking from 'web-client/mixins/onsite-notifications/tracking';
import moment from 'moment';

export default Component.extend(OnsiteNotificationTracking, {
  impressionTracking: injectService(),

  didInsertElement() {
    this._super(...arguments);
    this.get('impressionTracking').registerComponent(this, 'enteredViewport');
  },

  willDestroyElement() {
    this._super(...arguments);
    this.get('impressionTracking').deregisterComponent(this);
  },

  updatedAt: computed('notification.updatedAt', function() {
    return moment(this.get('notification.updatedAt')).fromNow();
  }),

  actions: {
    enteredViewport() {
      this.trackNotificationImpression('center', this.get('notification'));
      this.get('impressionTracking').deregisterComponent(this);
    }
  }
});
