/* globals Twitch */
import Component from 'ember-component';
import computed from 'ember-computed';
import injectService from 'ember-service/inject';
import ClickOutsideMixin from 'web-client/mixins/click-outside';

export default Component.extend(ClickOutsideMixin, {
  tracking: injectService(),
  presence: injectService('twitch-presence/presence'),

  isBalloonOpen: false,

  /**
   * Indicates the direction the selector should display in relative to the user's presence indicator
   * Options: `up`, `down`, `left`, `right`
   */
  direction: 'up',

  /**
   * These classes are applied to the component depending on the value of the `direction` attribute
   */
  downClass: 'balloon--down',
  leftClass: 'balloon--left',
  rightClass: 'balloon--right',
  upClass: 'balloon--up',

  directionClass: computed('direction', 'downClass', 'leftClass', 'rightClass', 'upClass', function () {
    let direction = this.get('direction');

    if (direction === 'up') {
      return this.get('upClass');
    } else if (direction === 'down') {
      return this.get('downClass');
    } else if (direction === 'left') {
      return this.get('leftClass');
    }
    return this.get('rightClass');
  }),

  clickedOutside() {
    this.set('isBalloonOpen', false);
  },

  actions: {
    toggleSelector() {
      this.toggleProperty('isBalloonOpen');
    },

    /**
     * Send a status update to the presence service and close the selector
     */
    setVisibility(visibility) {
      if (this.get('presence.settings.share') !== visibility) {
        this.get('tracking').trackEvent({
          event: 'share_mode_change',
          data: {
            login: Twitch.user.login(),
            share_mode: visibility === 'full' ? 'online' : 'invisible'
          }
        });
        // jscs:enable requireCamelCaseOrUpperCaseIdentifiers
      }
      this.get('presence').setVisibility(visibility);
      this.set('isBalloonOpen', false);
    }
  }
});
