/* globals i18n */
import Component from 'ember-component';
import injectService from 'ember-service/inject';
import computed from 'ember-computed';

export default Component.extend({
  presence: injectService('twitch-presence/presence'),

  labelText: i18n('Share my activity'),
  isSharingActivity: computed('presence.settings.share_activity', function() {
    return this.get('presence.settings.share_activity');
  }),

  actions: {
    toggleShareActivity() {
      this.get('presence').toggleShareActivity();
    }
  }
});
