/* globals i18n */

import Component from 'ember-component';
import computed from 'ember-computed';
import { htmlSafe } from 'ember-string';
import urlParams from 'web-client/utilities/url-params';
import {
  BROWSE_GAMES_REF as browseGamesRef,
  BASE_URL as primeBlogPostHref,
  getFaqUrl
} from 'web-client/utilities/urls/prime-urls';

const DEFAULT_MARKETPLACE = 'ATVPDKIKX0DER';
const BROWSE_NODES = {
  'ATVPDKIKX0DER': 'https://www.amazon.com/b?node=13584215011',
  'A13V1IB3VIYZZH': 'https://www.amazon.fr/b?node=11365189031',
  'A1RKKUPIHCS9HS': 'https://www.amazon.es/b?node=11301346031',
  'A1PA6795UKMFR9': 'https://www.amazon.de/b?node=11301327031',
  'APJ6JRA9NG5V4': 'https://www.amazon.it/b?node=11301380031',
  'A2EUQ1WTGCTBG2': 'https://www.amazon.ca/b?node=15281452011',
  'A1F83G8C2ARO7P': 'https://www.amazon.co.uk/b?node=11382284031'
};

export default Component.extend({

  browseNodeUrl: computed('primeSignupMarketplace', function() {
    let marketplace = urlParams.primeSignupMarketplace || DEFAULT_MARKETPLACE;
    if (BROWSE_NODES[marketplace].indexOf('?') >= 0) {
      return `${BROWSE_NODES[marketplace]}&${browseGamesRef}`;
    }
    return `${BROWSE_NODES[marketplace]}?${browseGamesRef}`;
  }),

  faqUrl: computed('', function() {
    return getFaqUrl();
  }),

  prBadgeDescription: computed('', function() {
    return htmlSafe(i18n('<strong class="pr-welcome__desc-emphasis">The badge of royalty. </strong>Appears next to your name in chat.'));
  }),
  gearIconPath: `<svg class="pr-welcome__gear" height="16" viewBox="0 0 16 16" width="16">
                  <path d="M6.359 0h3.282l1.436 2.8h3.282L16 5.2 14.359 8 16 10.8l-1.641 2.4h-3.282L9.64 16H6.359l-1.436-2.8H1.641L0 10.8 1.641 8 0 5.2l1.641-2.4h3.282L6.36 0zM8 11a3 3 0 1 0 0-6 3 3 0 0 0 0 6z"/>
                </svg>`,
  prBadgePostScript: computed('gearIconPath', function() {
    let desc = i18n('Manage your badges by clicking the [GEAR ICON] icon in chat.');
    desc = desc.replace('[GEAR ICON]', this.get('gearIconPath'));

    return htmlSafe(desc);
  }),
  settingsDescription: computed('', function() {
    let translated = i18n('Manage subscription notification under Settings > Twitch Prime');
    return htmlSafe(translated.replace('Twitch Prime', '<a href="https://www.twitch.tv/settings/prime" target="_new">Twitch Prime</a>'));
  }),

  primeBlogPostHref,

  actions: {
    goToRedirectRouteWithOffers() {
        this.sendAction('goToRedirectRouteWithOffers');
    },
    goToRedirectRouteWithSubModal() {
        this.sendAction('goToRedirectRouteWithSubModal');
    }
  }

});
