import computed from 'ember-computed';
import Component from 'ember-component';
import limitForDirectoryTower from 'web-client/utilities/tower';
import { CHANNEL_PREVIEW_MIN_WIDTH } from 'web-client/services/layout';

export const SHOW_ALL_STR = 'Show All';
export const SHOW_FEWER_STR = 'Show Fewer';

export default Component.extend({
  recommendedStream: null, // Must be provided
  channel: computed.reads('recommendedStream.channel'),
  streams: computed.reads('recommendedStream.streams'),
  isExpandable: true,
  showingAll: false,
  numRows: 2,

  toggleText: computed('showingAll', function() {
    return this.get('showingAll') ? SHOW_FEWER_STR : SHOW_ALL_STR;
  }),

  streamsPerRow: limitForDirectoryTower({
    minWidth: CHANNEL_PREVIEW_MIN_WIDTH
  }),

  streamsToShow: computed('streamsPerRow', 'streams.length', 'showingAll', 'numRows', function() {
    let streams = this.get('streams');
    let streamsPerRow = this.get('streamsPerRow');
    let numRows = this.get('numRows');
    let isExpandable = streams.length > streamsPerRow * 2;

    this.set('isExpandable', isExpandable);

    if (this.get('isExpandable') && !this.get('showingAll')) {
      return streams.slice(0, streamsPerRow * numRows - 1);
    }

    return streams;
  }),

  actions: {
    toggleViewAll() {
      this.toggleProperty('showingAll');
    }
  }
});
