/* globals i18n */

import Component from 'ember-component';
import computed from 'ember-computed';
import observer from 'ember-metal/observer';
import { htmlSafe } from 'ember-string';

export default Component.extend({
  tagName: 'iframe',
  classNames: ['twitter_share_button'],
  attributeBindings: ['style', 'src', 'scrolling'],
  style: htmlSafe("width:130px; height:20px;"),
  scrolling: "no",

  src: computed('url', 'message', 'via', function () {
    return `https://platform.twitter.com/widgets/tweet_button.html?text=${encodeURIComponent(this.get('message'))}&via=${this.get('via')}&url=${this.get('url')}`;
  }),

  srcChange: observer('src', function () {
    // this re-render prevents the duplicate history back stack bug
    // related: http://stackoverflow.com/questions/821359/reload-an-iframe-without-adding-to-the-history
    // details: https://www.facebook.com/yoh.suzuki/posts/10102834334028767?comment_id=21773222
    this.rerender();
  }),

  label: i18n('Tweet')
});
