/* globals i18n */
import Component from 'ember-component';
import computed from 'ember-computed';
import getOwner from 'ember-owner/get';
import VodAppeal from 'web-client/models/vod-appeal';

 /*
  An unstyled line of text to show what appeal actions you can take
  Parameters:
    Required:
      vodId
    Optional:
      showAppealsForm - action to render appeal form with
 */

export default Component.extend({
  vodId: '',

  init() {
    this._super(...arguments);

    let videoAppeal = VodAppeal.find(getOwner(this), this.get('vodId'));
    this.set('vodAppeal', videoAppeal);
  },

  appealText: computed('vodAppeal.canCreateAppeal', 'vodAppeal.canViewAppeal', function() {
    if (this.get('vodAppeal.canCreateAppeal')) {
      return i18n('Appeal Muted Audio');
    } else if (this.get('vodAppeal.canViewAppeal')) {
      return i18n('View Appeal');
    }
  }),

  actions: {
    showVodAppealsForm() {
      this.sendAction('showVodAppealsForm');
    }
  }
});
