import Component from 'ember-component';
import $ from 'jquery';

let REASONS = [
  {reason: 'incorrect_match', description: "My video does not contain the audio identified"},
  {reason: 'original_content', description: "I created and performed the original music without including any third party audio, and own all rights"},
  {reason: 'permission_rights', description: "I have permission from all applicable rights holders to use the audio and distribute it on Twitch as part of my video"},
  {reason: 'fair_use', description: "My use of the audio as part of my video on Twitch is fair use"}
];

// Translate reason keys like 'fair_use' given by API for pending appeals to longer description.
export let getReasonDescription = function (givenReason) {
  let reasonObject = REASONS.findBy('reason', givenReason);

  if (reasonObject) {
    return reasonObject.description;
  }
};

export default Component.extend({
  reasons: REASONS,

  didInsertElement() {
    this.addEventListener(document, 'mouseup', this.triggerHideReasonSelector.bind(this));
  },

  triggerHideReasonSelector(e) {
    let $el = $('.appeal-reason-menu');
    let selectorOpener = $el.parent().siblings('.drop'); // detect if the user is clicking on the dropmenu opener

    if (!$el.is(e.target) && $el.has(e.target).length === 0 && !$(e.target).is(selectorOpener)) {
      this.sendAction('stopSelectingReason');
    }
  },

  actions: {
    selectReason(reason) {
      this.sendAction('selectReason', reason);
    }
  }
});
