import Component from 'ember-component';
import computed from 'ember-computed';

export default Component.extend({
  channel: null,
  videoList: null,

  init() {
    this._super(...arguments);
  },

  didReceiveAttrs() {
    this._super(...arguments);
    if(this.get('channel.videos')){
      this.get('channel.videos').load(true).then((videos) => {
        this.set('videoList', videos);
      });
    }
  },

  showVideoList: computed('videoList.isLoading', function() {
    let videoList = this.get('videoList');
    if (videoList === null) {
      return false;
    }

    if (!('isLoading' in videoList) || videoList.get('isLoading') === true) {
      return false;
    }

    return videoList.get('content.length') > 0 ;
  })
});
