import Component from 'ember-component';
import injectService from 'ember-service/inject';
import computed from 'ember-computed';
import SendRouteActionMixin from 'web-client/mixins/send-route-action';
import VodCoviewsTrackingMixin from 'web-client/mixins/vod-coviews/tracking';

export default Component.extend(VodCoviewsTrackingMixin, SendRouteActionMixin, {
  tagName: 'li',
  classNames: ['card-carousel__item'],
  vodCoviews: injectService(),
  dismissed: null,
  feedbackSubmitted: null,

  video: computed.alias('content'),

  actions: {
    undoDismissClick() {
      this.get('vodCoviews').undoDismissRecommendation(this.get('video.id'), this.get('index'));
      this.set('dismissed', false);

      this.trackUndo(this.get('video'), this.get('index'));
    },

    openInModal() {
      this.sendRouteAction('openInModal', 'components/vod-coview-dismiss-modal', this);
    },

    closeModal() {
      this.sendRouteAction('closeModal', this);
    },

    submitFeedback(text, reason) {
      this.sendRouteAction('closeModal', this);
      this.set('feedbackSubmitted', true);

      this.trackSubmitFeedback(this.get('video'), this.get('index'), reason, text);
    },

    handleDismissClick() {
      this.get('vodCoviews').dismissRecommendation(this.get('video.id'));
      this.set('dismissed', true);

      this.trackDismiss(this.get('video'), this.get('index'));
    }
  }
});
