import Component from 'ember-component';
import DeprecatedVideo from 'web-client/models/deprecated-video';
import computed from 'ember-computed';
import { scheduleOnce } from 'ember-runloop';
import injectService from 'ember-service/inject';
import { UPLOAD_TYPE_PARAM } from 'web-client/utilities/video/types';
import InteractivityDeferredComponent from 'web-client/mixins/interactivity-deferred-component';

export default Component.extend(InteractivityDeferredComponent, {
  session: injectService(),
  experiments: injectService(),
  showUploads: false,

  init() {
    this._super(...arguments);
    this.get('experiments').getExperimentValue('VOD_UPLOAD_UNITS').then((value) => {
      if (this.isDestroyed) { return; }
      this.set('showUploads', value === 'experiment');
      scheduleOnce('afterRender', this, this.reportInteractive); // The request below may not be tracked, but there's no promise to hook into
    });
  },

  videos: computed('showUploads', function() {
    if (!this.get('showUploads')) {
      return [];
    }

    return DeprecatedVideo.find('following', { broadcastType: UPLOAD_TYPE_PARAM }).load();
  })
});
