import Component from 'ember-component';
import computed from 'ember-computed';
import DeprecatedVideo from 'web-client/models/deprecated-video';

export default Component.extend({
  boxArt: computed.readOnly('video.gameBoxArt'),
  gameHref: computed.readOnly('video.gameUrl'),
  showItemBoxart: computed.not('video.game'),

  didReceiveAttrs() {
    this._super(...arguments);
    return this.get('videos').load();
  },

  videos: computed('video.game', function() {
    let game = this.get('video.game');
    let videos = DeprecatedVideo.find('game', { game , period: 'week' });
    return videos;
  })
});
