import Component from 'ember-component';

export default Component.extend({
  tagName: 'li',
  classNames: ['selectable', 'js-selectable'],
  classNameBindings: ['restricted'],

  didInsertElement() {
    this._super(...arguments);
    this.initHover();
  },

  initHover() {
    let element = this.$();
    element.hover(() => {
      element.addClass('over');
      element.prevAll().addClass('over');
      element.nextAll().removeClass('over');
    }, () => {
      element.removeClass('over');
    });
  },

  willDestroyElement() {
    this._super(...arguments);
    /* Teardown hower listeners */
    this.$().off('mouseenter mouseleave');
  },

  click() {
    this.get('toggle')();
  }
});
