import Component from 'ember-component';
import { schedule } from 'ember-runloop';

export default Component.extend({
  visible: true,

  didUpdateAttrs() {
    this._super(...arguments);
    schedule('afterRender', this, 'setVideoDimensions');
  },

  didInsertElement() {
    this._super(...arguments);

    this.addEventListener(window, 'resize', function() {
      schedule('afterRender', this, 'setVideoDimensions');
    });
  },

  setVideoDimensions: function() {
    if (this.get('visible')) {
      let videoMaxWidth = 300;
      let videoMargin = 20;

      let listWidth = this.$().width() + videoMargin;

      // Allow videos to be larger than the normal max to have a single column large video
      // instead of two column tiny videos
      if (listWidth <= 340) {
        videoMaxWidth = 340;
      }

      let videosPerRow = Math.ceil(listWidth / videoMaxWidth);
      let videoWidth = listWidth / videosPerRow;

      this.set('videoWidth', videoWidth);
    }
  },

  actions: {
    loadMore() {
      this.get('videos').loadMore();
    }
  }
});
