import Component from 'ember-component';
import injectService from 'ember-service/inject';
import computed from 'ember-computed';
import { CREATIVE } from 'web-client/utilities/game-names';

export default Component.extend({
  classNames: ['metadata-box', 'qa-metadata-box'],
  session: injectService(),
  community: injectService(),

  tags:  computed('vodModel.title', function(){
    return this.get('community').extractFromTags(this.get('vodModel.title'));
  }),

  boxArt: computed.readOnly('vodModel.gameBoxArt'),

  isCreative: computed.equal('vodModel.game', CREATIVE),

  gameHref: computed.readOnly('vodModel.gameUrl'),

  actions: {
    openEditModal() {
      this.set('isEditing', true);
    },

    closeEditModal() {
      this.set('isEditing', false);
    }
  }
});
