import Component from 'ember-component';
import computed from 'ember-computed';
import { htmlSafe } from 'ember-string';
import { ARCHIVE_TYPE_PARAM } from 'web-client/utilities/video/types';

export default Component.extend({
  classNames: ['brick', 'brick--pd-none', 'brick--theme-white', 'cn-vod-info'],
  vodDescription: computed('descriptionHTML', function() {
    return htmlSafe(this.get('descriptionHTML'));
  }),
  vodBroadcastType: computed.readOnly('broadcastType'),
  isExpanded: false,

  displayedBroadcastType: computed('vodBroadcastType', function() {
    let broadcastType = this.get('vodBroadcastType');
    if (broadcastType === ARCHIVE_TYPE_PARAM) {
      return 'Past Broadcast';
    }
    return broadcastType.capitalize();
  }),

  toggledText: computed('isExpanded', function() {
    return this.get('isExpanded') ? 'Show Less' : 'Show More';
  }),

  actions: {
    toggleExpand() {
      this.toggleProperty('isExpanded');
    }
  }
});
