import Component from 'ember-component';
import injectService from 'ember-service/inject';
import { scheduleOnce } from 'ember-runloop';
import InteractivityDeferredComponent from 'web-client/mixins/interactivity-deferred-component';

export default Component.extend(InteractivityDeferredComponent, {
  recentUploads: injectService(),

  init() {
    this._super(...arguments);
    this.set('uploads', []);
    let recentUploads = this.get('recentUploads');
    let channel = this.get('channel');
    recentUploads.getRecentUploads(channel).then((uploads) => {
      if (this.isDestroyed) { return; }
      this.set('uploads', uploads);
      let numUploads = this.get('uploads.length');
      this.set('showUploads', numUploads > 0);
      scheduleOnce('afterRender', this, this.reportInteractive);
    });
  }
});
