import ChatLine, { BADGE_PROPERTIES } from 'web-client/components/chat/chat-line/component';
import moment from 'moment';
import { capitalize } from 'web-client/helpers/chat/chat-line-helpers';
import computed from 'ember-computed';
import injectService from 'ember-service/inject';

const BADGE_PROPERTY_KEYS = Object.keys(BADGE_PROPERTIES);

export default ChatLine.extend({
  // Inherited from ChatLine:
  // msgObject, isChannelLinksDisabled, currentUserNick, isViewerModeratorOrHigher, enableLinkification => public things
  // tokenizedMessage, colorStyle, fromStyle, messageStyle, isModeratorOrHigher, showStaffBadge, showAdminBadge, showGlobalModBadge
  // showModeratorBadge, hasTurboTag, canRenderBits

  classNames: [
    'chat-line'
  ],

  // "gray" is used in JS, but "grey" in CSS.
  classNameBindings: [
    'isTmiMessage:notification',
    'isGrayedOut:chat-line--greyed-out'
  ],

  tagName: 'li',

  badges: injectService(),

  messageStyle: computed('msgObject.tags.style', 'fromStyle', function () {
    if (this.get('msgObject.tags.style') === 'action') {
      return this.get('fromStyle');
    }
    return '';
  }),

  isBroadcaster: computed('msgObject.{from,room}', function () {
    let msgObject = this.get('msgObject');
    return msgObject.get('from') === msgObject.get('room');
  }),

  isStaff: computed.equal('msgObject.tags.user-type', 'staff'),

  isAdmin: computed.equal('msgObject.tags.user-type', 'admin'),

  isGlobalMod: computed.equal('msgObject.tags.user-type', 'global_mod'),

  isSubscriber: computed.bool('msgObject.tags.subscriber'),

  isModerator: computed.bool('msgObject.tags.mod'),

  isTmiMessage: computed.equal('msgObject.from', 'twitchnotify'),

  isMsgModeratable: computed('isViewerModeratorOrHigher', 'isModeratorOrHigher', function () {
    return this.get('isViewerModeratorOrHigher') && !this.get('isModeratorOrHigher');
  }),

  hasTurbo: computed.alias('hasTurboTag'),

  timestamp: computed('msgObject.timestamp', 'videoStartedAt', function () {
    let vodCreatedAtUnixMilliseconds = moment.utc(this.get('videoStartedAt')).valueOf();
    let distance = this.get('msgObject.timestamp') - vodCreatedAtUnixMilliseconds;
    return moment.utc(distance).format('HH:mm:ss');
  }),

  isGrayedOut: computed('msgObject.{grayed,deletedGrayed}', function () {
    let msgObject = this.get('msgObject');
    return msgObject.get('grayed') || msgObject.get('deletedGrayed');
  }),

  badgeSet: computed('msgObject.tags.badges', function () {
    let badges = [];
    let badgesTag = this.get('msgObject.tags.badges') || {};

    // Use old subscriber badge flow if message has subscriber=1 tag
    if (!badgesTag) {
      for (let i = 0; i < BADGE_PROPERTY_KEYS.length; i++) {
        let key = BADGE_PROPERTY_KEYS[i];
        if (this.get(key)) {
          badges.push(BADGE_PROPERTIES[key]);
        }
      }
      return badges;
    }

    if (typeof badgesTag === 'string') {
      badgesTag = this.get('badges').parseBadgesTag(badgesTag);
    }

    return this.get('badges').getBadgesData(badgesTag);
  }),

  fromText: computed("msgObject.tags.display-name", "msgObject.from", function () {
    let msgObject = this.get('msgObject');
    return msgObject.get('tags.display-name') || capitalize(msgObject.get('from'));
  })

});
