import Component from 'ember-component';
import computed from 'ember-computed';
import injectService from 'ember-service/inject';

export default Component.extend({
  classNameBindings: ['hasWatched:video-watched'],
  vodResumeWatching: injectService(),
  vodGameInfo: injectService(),
  hasResumeTime: computed.notEmpty('resumeTime'),
  hasWatched: false,
  isGameBoxartVisible: computed('hasResumeTime', 'vodGameInfo.isUnwatchedBoxartViewable', function () {
    return !this.get('hasResumeTime') && this.get('vodGameInfo.isUnwatchedBoxartViewable');
  }),

  init() {
    this._super(...arguments);

    let id = this.get('video.id');
    let broadcastId = this.get('video.broadcast_id');
    let broadcastType = this.get('video.broadcast_type');
    this.get('vodResumeWatching').getResumeTime(id, broadcastId, broadcastType).then(
      resumeTime => {
        if (this.isDestroyed || resumeTime === null) { return; }
        if (resumeTime !== 0) {
          this.set('resumeTime', resumeTime);
        }
        this.set('hasWatched', true);
      });
  }
});
