import $ from 'jquery';
import Component from 'ember-component';
import injectService from 'ember-service/inject';
import computed from 'ember-computed';

export default Component.extend({
  layout: injectService(),
  tracking: injectService(),

  elementId: 'right_col',
  classNameBindings: ['layout.isRightColumnClosed:closed:open', ':column', ':fixed'],
  showFirstTab: computed.alias('firstTabSelected'),
  firstTabSelected: true,
  secondTab: true,
  firstTab: true,

  willDestroyElement() {
    $('#chat_settings_dropmenu, .js-chatters-container').hide();
    $('#chat_lines').off('scroll');
  },

  selectFirstTab() {
    this.set('firstTabSelected', true);
  },

  selectSecondTab() {
    this.set('firstTabSelected', false);
  },

  actions: {
    handleSecondTabClick() {
      this.selectSecondTab();
    },
    handleFirstTabClick() {
      this.selectFirstTab();
    },
    handleHideAd() {
      $('.js-new-channel-ad .js-adhide').hide();
      $('.js-rightcol-content').css('top', '0px');

      this.get('tracking').trackEvent({
        event: 'channel-adclose',
        services: ['mixpanel']
      });
    }
  }
});
