import Component from 'ember-component';
import { assert } from 'ember-metal/utils';
import injectService from 'ember-service/inject';
import Video from 'web-client/models/video';

export default Component.extend({
  store: injectService(),
  attributeBindings: ['testSelector:data-test-selector'],
  itemSelected: false,
  isAdded: false,

  onClick() {},
  testSelector: '',
  video: null,

  didReceiveAttrs({ newAttrs }) {
    if (newAttrs && newAttrs.video) {
      assert('Video must be video model', newAttrs.video instanceof Video);
    }
  },

  click() {
    this.get('onClick')(this.get('video'));
  }
});
