import Component from 'ember-component';
import injectService from 'ember-service/inject';

const MIN_COUNT_UPLOADS = 5;
const MIN_VIEWS_UPLOADS = 5;

export default Component.extend({
  trendingUploads: injectService(),

  showUploads: false,

  _filterUploadsByViewCount(uploads) {
    return uploads.filter(function(upload) {
      return upload.views >= MIN_VIEWS_UPLOADS;
    });
  },

  init() {
    this._super(...arguments);
    this.set('uploads', []);
    let trendingUploads = this.get('trendingUploads');
    let game = this.get('game');
    trendingUploads.getTrendingUploads(game).then((uploads) => {
      if (this.isDestroyed) { return; }
      let filteredUploads = this._filterUploadsByViewCount(uploads);
      this.set('uploads', filteredUploads);
      let numUploads = this.get('uploads.length');
      this.set('showUploads', numUploads >= MIN_COUNT_UPLOADS);
    });
  }
});
