import ChannelRedesignComponent from 'web-client/components/channel-redesign/component';
import injectService from 'ember-service/inject';
import computed from 'ember-computed';
import SendRouteAction from 'web-client/mixins/send-route-action';
import { TOP_NAV_HEIGHT } from 'web-client/services/layout';

export default ChannelRedesignComponent.extend(SendRouteAction, {
  experiments: injectService(),
  recsHoldout: injectService('recs-holdout'),
  session: injectService(),
  persistentPlayer: injectService(),

  showRelatedVodsFirst: computed.equal('vodRecommendationsOrder', 'related_first'),
  showRecentVodsFirst: computed.equal('vodRecommendationsOrder', 'recent_first'),
  canGenerateClips: computed.readOnly('session.isAuthenticated'),

  init() {
    this._super(...arguments);

    this.get('experiments').getExperimentValue('VOD_PAGE_RECOMMENDATION_ORDER').then(value => {
      if (this.isDestroyed) { return; }
      this.set('vodRecommendationsOrder', value);
    });
  },

  didReceiveAttrs() {
    this._super(...arguments);
    if (this.$scrollContainer) {
      this.scrollTo(0);
    }
  },

  didInsertElement() {
    this._super();

    let $placeholder = this.$('.player-placeholder');
    this.$playerPlaceholder = $placeholder.length > 0 ? $placeholder : null;

    this.updatePlayerPosition();

    if (!this.get('persistentPlayer.isFullSize') && this.get('persistentPlayer.isVisible')) {
      this.sendRouteAction('anchorPlayer', 'maximize');
    } else {
      this.sendRouteAction('showPlayer');
    }
  },

  didRender() {
    this.updatePlayerPosition();
  },

  updatePlayerPosition() {
    if (!this.$playerPlaceholder) {
      return;
    }

    let $scrollContainer = this.$playerPlaceholder.scrollParent();
    let playerOffset = this.$playerPlaceholder.offset();
    let playerTop = playerOffset.top + $scrollContainer.scrollTop();
    let playerLeft = playerOffset.left - $scrollContainer.offset().left;

    if (this.get('layout.isSocialColumnEnabled')) {
      playerTop -= TOP_NAV_HEIGHT;
    }

    this.set('persistentPlayer.fullSizePlayerLocation', {
      top: playerTop,
      left: playerLeft
    });
  }
});
