import computed from 'ember-computed';
import Controller from 'ember-controller';
import injectService from 'ember-service/inject';
import injectController from 'ember-controller/inject';

export default Controller.extend({
  application: injectController(),
  layout: injectService(),
  // NOTICE: The login service is deprecated, plesase use the session service.
  // See app/services/SESSION.md for more details.
  login: injectService(),

  filteredTickets: computed.uniqBy('content', 'product.short_name'),

  loadMore: function () {
    this.get('content').loadMore();
  }
});
