/* globals Twitch */

import Controller from 'ember-controller';
import injectService from 'ember-service/inject';
import computed from 'ember-computed';

export default Controller.extend({
  session: injectService(),

  permissionsHref: computed('model.id', function () {
    return this._dashboardUrl('permissions');
  }),

  actionLogHref: computed('model.id', function () {
    return this._dashboardUrl('action_log');
  }),

  statsHref: computed('model.id', function () {
    return this._dashboardUrl('stats');
  }),

  isStaff: computed.readOnly('session.userData.is_staff'),

  isAdmin: computed.readOnly('session.userData.is_admin'),

  isOwner: computed('model.id', function () {
    return this.get('session').userData.login === this.get('model.id');
  }),

  hasPartnerProgram: computed.bool('model.partner'),

  activeVideoStatsTab: false,

  _dashboardUrl(section) {
    return Twitch.uri.dashboards(this.get('model.id'), section);
  }
});
