/* global i18n */

import Controller from 'ember-controller';
import computed from 'ember-computed';
import injectService from 'ember-service/inject';

const SAVE_SUCCESS = i18n('Ad Setting Changes Are Saved');
const SAVE_FAILURE = i18n('Ad Setting Changes Failed');

export default Controller.extend({
  notify: injectService(),

  isSaving: false,
  isShowingWarningModal: false,

  isHideAds: computed.alias('model.hideAds'),

  actions: {
    save() {
      if (this.get('isSaving')) { return; }

      this.set('isSaving', true);

      let notify = this.get('notify');
      let savePromise = this.get('model').save();

      savePromise.then(() => {
        if (this.isDestroyed) { return; }

        notify.success(SAVE_SUCCESS);
      }, () => {
        if (this.isDestroyed) { return; }

        notify.failure(SAVE_FAILURE);
      }).finally(() => {
        if (this.isDestroyed) { return; }

        this.set('isSaving', false);
      });

      return savePromise;
    },

    checkboxChanged(isHideAds) {
      this.set('isHideAds', isHideAds);

      if (!isHideAds) {
        this.set('isShowingWarningModal', true);
      }
    },

    cancelModal() {
      this.set('isHideAds', true);
      this.set('isShowingWarningModal', false);
    },

    confirmModal() {
      this.set('isShowingWarningModal', false);
    }
  }
});
