/* globals i18n */

import Controller from 'ember-controller';
import computed from 'ember-computed';
import injectService from 'ember-service/inject';

const SAVE_SUCCESS = i18n('Chat Restriction Changes Are Saved');

export default Controller.extend({
  notify: injectService(),

  subsonlyLocal: computed.alias('model.subsonly'),
  fastsubsLocal: computed.alias('model.fastsubs'),
  isSaving: false,

  save() {
    if (this.get('isSaving')) { return; }

    let notify = this.get('notify');

    this.set('isSaving', true);

    return this.get('content').save().then(() => {
      if (this.isDestroyed) { return; }

      notify.success(SAVE_SUCCESS);
    }).finally(() => {
      if (this.isDestroyed) { return; }

      this.set('isSaving', false);
    });
  }
});
