/* global i18n */

import Controller from 'ember-controller';
import computed from 'ember-computed';
import injectService from 'ember-service/inject';

const SAVE_SUCCESS = i18n('Creative Settings Changes Are Saved');
const SAVE_ERROR = i18n('Oops, something went wrong. Please try again.');

export default Controller.extend({
  notify: injectService(),

  commissionPlaceholderText: i18n('Hey!  I do commissions of all kinds and would love to do a piece of work for you!'),

  commission_button: computed.alias('model.creative.commission_button'),

  commission_text: computed.alias('model.creative.commission_text'),

  isSaving: false,

  save() {
    if (this.get('isSaving')) { return; }

    let notify = this.get('notify');

    this.set('isSaving', true);

    return this.get('model').save().then(() => {
      if (this.isDestroyed) { return; }

      notify.success(SAVE_SUCCESS);
    }, () => {
      if (this.isDestroyed) { return; }

      notify.error(SAVE_ERROR);
    }).finally(() => {
      if (this.isDestroyed) { return; }

      this.set('isSaving', false);
    });
  }
});
