import Controller from 'ember-controller';
import injectService from 'ember-service/inject';
import computed from 'ember-computed';

export default Controller.extend({
  globals: injectService(),

  // Properties set by the route:
  areCheersPinned: null,
  hasSubBadges: null,
  isBitsOnboarded: null,
  isBitsRecipientEligible: null,
  isBitsTagsEnabled: null,
  isPayable: null,

  // Own properties:
  isIndividualPartner: computed.readOnly('model.payoutEntity.individual_partner'),

  hasSetProduct: computed.notEmpty('model.product'),
  hasSetName: computed.notEmpty('model.product.customName'),
  hasSetEmoticon: computed.notEmpty('model.product.emoticons'),
  hasSetSubonlyArchives: computed.readOnly('model.product.subonlyArchives'),
  hasSetFastsubs: computed.readOnly('model.product.fastsubs'),
  hasSetSubsonly: computed.readOnly('model.product.subsonly'),
  hasSetAdFreeForSubscribers: computed.readOnly('model.product.hideAds'),
  hasSourceTranscode: computed.equal('model.product.availableTranscode', 'source'),
  hasRoyaltyTaxSuccess: computed.equal('model.product.royaltyTaxState', 'success'),

  isNetPaymentAmendmentAccepted: computed('model.product.netPaymentAmendment', function () {
    let amendment = this.get('model.product.netPaymentAmendment');

    return amendment === 'accepted_by_default' || amendment === 'signed';
  }),

  isStreamingCreative: computed.readOnly('model.product.creative.streaming_creative'),

  isTeespringEnabled: computed.readOnly('model.product.teespringEnabled'),
  hasTeespringCampaign: computed.notEmpty('model.product.teespringCampaign'),

  isPinCheerEnabled: computed.readOnly('globals.pCheerEnabled')
});
