import Controller from 'ember-controller';
import computed from 'ember-computed';

export default Controller.extend({
  hasTeespringCampaign: computed.bool('model.teespringCampaign'),
  isPending: computed.equal('model.teespringCampaign.state', 'pending'),
  isActive: computed.equal('model.teespringCampaign.state', 'active'),
  isTeespringConnected: computed.bool('model.teespringConnected'),

  actions: {
    viewCampaign() {
      let id = this.get('model.teespringCampaign.teespring_id');
      window.location = `https://teespring.com/auth/twitch?origin=/campaigns/${id}/edit`;
    },

    createCampaign() {
      window.location = 'https://teespring.com/auth/twitch?origin=/design';
    },

    redirectSettings() {
      window.location = '/settings/connections';
    }
  }
});
