/* global i18n */

import Controller from 'ember-controller';
import injectService from 'ember-service/inject';

const SAVE_FAILURE = i18n('Oops, something went wrong. Please try again.');
const SAVE_SUCCESS = i18n('Subscription Information Changes Are Saved');
const TICKET_NAME_PLACEHOLDER = i18n('Enter the name for your subscription ticket');

export default Controller.extend({
  notify: injectService(),

  ticketNamePlaceholderText: TICKET_NAME_PLACEHOLDER,
  isSaving: false,

  save() {
    if (this.get('isSaving')) { return; }

    let notify = this.get('notify');

    this.set('isSaving', true);

    return this.get('model').save().then(() => {
      if (this.isDestroyed) { return; }

      notify.success(SAVE_SUCCESS);
    }, () => {
      if (this.isDestroyed) { return; }

      notify.error(SAVE_FAILURE);
    }).finally(() => {
      if (this.isDestroyed) { return; }

      this.set('isSaving', false);
    });
  }
});
