/* globals i18n */

import utils from 'web-client/utilities/main';
import computed from 'ember-computed';
import Controller from 'ember-controller';
import injectService from 'ember-service/inject';
import injectController from 'ember-controller/inject';
import { CREATIVE } from 'web-client/utilities/game-names';

let AllChannelsController = Controller.extend({
  // CONTROLLER DEPENDENCIES
  /* dependencies and external bindings */
  layout: injectService(),
  application: injectController(),
  channelsBroadcasterLanguage: injectController('directory/channels/broadcaster-language'),
  browse: injectService(),
  languageDirectoryFilter: injectService(),

  isBrowseExperimentEnabled: computed.readOnly('browse.isBrowseExperimentEnabled'),

  // CONTROLLER PROPERTIES
  /* these are mapped to the view */

  isLoading: computed.alias('content.isLoading'),
  showLanguageDirectoryFilter: computed('content.type', function () {
    if (['psFour', 'xbOne', 'random'].includes(this.get('content.type'))) {
      return false;
    }
    return true;
  }),

  title: computed('content.type', 'content.game', function () {
    if (this.get('content.game') === CREATIVE) {
      return i18n('Top Channels From Creative');
    }
    switch (this.get('content.type')) {
    case 'top':
      return i18n('Top Channels');
    case 'random':
      return i18n('Random Channels');
    case 'psFour':
      return i18n('Top Channels From PlayStation 4');
    case 'xbOne':
      return i18n('Top Channels From Xbox One');
    case 'bygame':
      return this.get('content.game');
    case 'live':
      return i18n('Channels You Follow');
    }
  }),

  // HANDLE EVENTS
  /* events object and handlers */

  // PUBLIC FUNCTIONS
  /* expose some specific ways to change the data behind the template */

  actions: {
    loadMoreChannels() {
      if (this.get('content')) {
        this.get('content').loadMore();
      }
    }
  }
});

utils.setOnReady(AllChannelsController, {
  propertyName: 'languageChannelsCountPromise',

  readyToResolveCondition: computed('channelsBroadcasterLanguage.content.total', 'channelsBroadcasterLanguage.content.isLoading', function () {
    return this.get('channelsBroadcasterLanguage.content.total') !== undefined &&
           !this.get('channelsBroadcasterLanguage.content.isLoading');
  }),

  value: function () {
    return this.get('channelsBroadcasterLanguage.content.total');
  }
});

export default AllChannelsController;
