/* globals i18n */

import Controller from 'ember-controller';
import computed from 'ember-computed';
import injectService from 'ember-service/inject';
import limitForDirectoryTower from 'web-client/utilities/tower';
import { CHANNEL_PREVIEW_MIN_WIDTH } from 'web-client/services/layout';

export default Controller.extend({
  globals: injectService(),
  broadcasterLanguages: computed.alias('globals.broadcasterLanguages'),

  layout: injectService(),
  browse: injectService(),

  isBrowseExperimentEnabled: computed.readOnly('browse.isBrowseExperimentEnabled'),

  hideSection: false,
  isLoading: computed.alias('content.isLoading'),

  maxItems: limitForDirectoryTower({
    minWidth: CHANNEL_PREVIEW_MIN_WIDTH,
    rowCount: 2
  }),

  liveChannelText: computed('languageName', function () {
    let translatedFormat = i18n("Channels in {{language}}");
    return translatedFormat.replace('{{language}}', this.get('languageName'));
  }),

  hasChannels: computed('content.length', function () {
    return this.get('content.length') > 0;
  }),

  sampleChannels: computed('content.length', 'content.isLoading', 'maxItems', 'hasMoreStreams', function () {
    let sampleCount = this.get('maxItems');

    // Reserve a spot for "View All" button
    if (this.get('hasMoreChannels')) {
      sampleCount--;
    }

    return this.get('content.content').slice(0, sampleCount);
  }),

  hasMoreChannels: computed('content.length', 'maxItems', function () {
    return this.get('content.length') > this.get('maxItems');
  }),

  languageCode: computed('model', function () {
    return this.get('model').get('broadcaster_language');
  }),

  languageName: computed('broadcasterLanguages', 'languageCode', function () {
    return this.get('broadcasterLanguages')[this.get('languageCode')];
  }),

  actions: {
    loadMoreStreams: function () {
      if (this.get('content')) {
        this.get('content').loadMore();
      }
    },

    toggleHidden: function () {
      this.set('layout.hideLocalizedContentSection', !this.get('layout.hideLocalizedContentSection'));
    }
  }
});
