/* globals Twitch */
import Controller from 'ember-controller';
import injectService from 'ember-service/inject';
import injectController from 'ember-controller/inject';
import computed from 'ember-computed';
import SendRouteActionMixin from 'web-client/mixins/send-route-action';
import $ from 'jquery';

export default Controller.extend(SendRouteActionMixin, {
  application: injectController(),

  layout: injectService(),
  session: injectService(),
  browse: injectService(),

  isBrowseExperimentEnabled: computed.readOnly('browse.isBrowseExperimentEnabled'),

  communitiesSort: ['viewers:desc'],
  sortedCommunities: computed.sort('communities', 'communitiesSort'),
  isLoading: computed.empty('sortedCommunities'),
  noLiveChannels: computed.equal('communities._total', 0),

  init() {
    this._super(...arguments);
    this.communities = [];
    Twitch.tracking.funnel.trackPageView({location: "community_directory"});
  },

  loadMoreTopCommunities: function () {
    this.send('loadMoreTopCommunities');
  },

  actions: {
    createCommunity() {
      if (!this.get('session').isAuthenticated) {
        $.login({mpSourceAction: 'community-create'});
        return;
      }
      this.sendRouteAction('handleCommunityClick');
    }
  }
});
