import Controller from 'ember-controller';
import injectService from 'ember-service/inject';
import computed from 'ember-computed';

export default Controller.extend({
  similarChannels: injectService(),
  storage: injectService(),
  recsHoldout: injectService('recs-holdout'),
  vodCoviews: injectService(),
  experiments: injectService(),
  browse: injectService(),

  isBrowseExperimentEnabled: computed.readOnly('browse.isBrowseExperimentEnabled'),

  discoverCoviews: undefined,
  discoverShowCoviews: computed.equal('discoverCoviews', 'show'),
  showRecentlyWatchedStreams: false,

  init() {
    this._super(...arguments);

    this.get('experiments').getExperimentValue('DISCOVER_SHOW_COVIEWS').then(value => {
      if (this.isDestroyed) { return; }
      this.set('discoverCoviews', value);
    });
  },

  actions: {
    dismiss() {
      this.set('storage.userLearnedMoreAboutDiscovery', true);
    }
  }
});
