import Controller from 'ember-controller';
import utils from 'web-client/utilities/main';
import computed from 'ember-computed';
import injectController from 'ember-controller/inject';
import injectService from 'ember-service/inject';
import limitForDirectoryTower from 'web-client/utilities/tower';
import { CHANNEL_PREVIEW_MIN_WIDTH } from 'web-client/services/layout';

let FollowingController = Controller.extend({
  globals: injectService(),
  disableFollowingDirectory: computed.alias('globals.disableFollowingDirectory'),
  followingVideosEnabled: computed.alias('globals.followingVideosEnabled'),
  application: injectController(),
  session: injectService(),
  browse: injectService(),

  isBrowseExperimentEnabled: computed.readOnly('browse.isBrowseExperimentEnabled'),

  followingChannels: injectController('directory/following/channels'),
  followingHosts: injectController('directory/following/hosts'),
  followingGames: injectController('directory/following/games'),
  followingVideos: injectController('directory/following/videos'),
  hasFollows: computed.alias('model.total'),

  maxVodsPerRow: limitForDirectoryTower({
    minWidth: CHANNEL_PREVIEW_MIN_WIDTH,
    rowCount: 2
  }),

  showNavigation: computed('channels.isLoading', 'channels.total', 'disableFollowingDirectory', 'followingVideosEnabled', 'isLoadingFollowsCount', function () {
    if (this.get('disableFollowingDirectory')) {
      return true;
    }
    return this.get('followingVideosEnabled') && !this.get('isLoadingFollowsCount') && this.get('channels.total');
  })
});

utils.setOnReady(FollowingController, {
  propertyName: 'followingCountPromise',

  readyToResolveCondition: computed('followingChannels.content.isLoading', function () {
    return !this.get('followingChannels.content.isLoading');
  }),

  value: function () {
    return this.get('followingChannels.content.total');
  }
});

utils.setOnReady(FollowingController, {
  propertyName: 'followingHostsCountPromise',

  readyToResolveCondition: computed('followingHosts.content.isLoading', function () {
    return !this.get('followingHosts.content.isLoading');
  }),

  value: function () {
    return this.get('followingHosts.content.total');
  }
});

utils.setOnReady(FollowingController, {
  propertyName: 'followingGamesCountPromise',

  readyToResolveCondition: computed('followingGames.content.isLoading', function () {
    return !this.get('followingGames.content.isLoading');
  }),

  value: function () {
    return this.get('followingGames.content.total');
  }
});

utils.setOnReady(FollowingController, {
  propertyName: 'followingVideosCountPromise',

  readyToResolveCondition: computed('followingVideos.model.isLoading', function () {
    return !this.get('followingVideos.model.isLoading');
  }),

  value: function () {
    return this.get('followingVideos.content.length');
  }
});

export default FollowingController;
